#include <stdio.h>
#include <ctype.h>

#include <expat.h>

static int	alternate_output;

static int	depth;
static int	tagnr, attnr;
static char	*prefix	= "t_xmltosql_";
static char	*id	= "null";

struct dynstring
  {
    long	len;
    char	*s;
  };

static struct scope
  {
    struct dynstring	data;
    int			tag;
  } scope, hist[16];


static void *
re_alloc(void *ptr, size_t len)
{
  ptr	= (ptr ? realloc(ptr, len) : malloc(len));
  if (!ptr)
    {
      perror("out of memory");
      exit(1);
    }
  return ptr;
}

static void
dynstring_add(struct dynstring *s, const void *p, size_t len)
{
  s->s	=  re_alloc(s->s, s->len+len);
  memcpy(s->s+s->len, p, len);
  s->len	+= len;
}

static void
dynstring_free(struct dynstring *s)
{
  if (s->s)
    free(s->s);
  s->s		= 0;
  s->len	= 0;
}


static void
put_sql(const char *s, int len)
{
  while (--len>=0)
    {
      if (*s=='\'')
        putchar('\'');
      putchar(*s++);
    }
}

static void
put(const char *s, int len)
{
  while (--len>=0)
    {
      switch (*s)
	{
	  // This are mysql specials
	case 0:    printf("\\0"); s++; break;
	  // need not to be escaped but makes it more readable
	case 26:   printf("\\z"); s++; break;
	case '\b': printf("\\b"); s++; break;
	case '\n': printf("\\n"); s++; break;
	case '\r': printf("\\r"); s++; break;
	case '\t': printf("\\t"); s++; break;

	  // The quotes and escapes
	case '\\':
	case '\'':
	case '\"':
	  printf("\\");
	default:
	  putchar(*s++);
	  break;
	}
    }
}

static void
output(const char *s, size_t len)
{
  if (!s)
    printf("null");
  else
    {
      putchar('\'');
      if (alternate_output)
	put_sql(s, len);
      else
        put(s, len);
      putchar('\'');
    }
}

static void
outputs(const char *s)
{
  output(s, strlen(s));
}

static void
dumpl(const char *t, const char *s, int len)
{
  printf("#%d %s '", depth, t);
  put(s, len);
  printf("'\n");
}

static void
dump(const char *t, const char *s)
{
  dumpl(t, s, strlen(s));
}

static void
parser_start(void *user, const XML_Char *name, const XML_Char **attr)
{
  int			i;

  hist[depth++]	= scope;
  memset(&scope, 0, sizeof scope);
  scope.tag	= tagnr++;

  //  dump("start", name);
  for (i=0; attr[i]; )
    {
      printf("insert into %satt values (%s, %d, %d, ", prefix, id, attnr++, scope.tag);
      outputs(attr[i++]);
      printf(", ");
      outputs(attr[i++]);
      printf(");\n");
    }
}

static void
parser_end(void *user, const XML_Char *name)
{
  
  while (scope.data.len && isspace(scope.data.s[scope.data.len-1]))
    scope.data.len--;
  //  if (scope.data.len)
  //    dumpl("total", scope.data.s, scope.data.len);
  //  dump("end", name);

  printf("insert into %sent values (%s, %d, %d, %d, ", prefix, id, scope.tag, depth-1, hist[depth-1].tag);
  outputs(name);
  printf(", ");
  output(scope.data.s, scope.data.len);
  printf(");\n");

  dynstring_free(&scope.data);
  scope	= hist[--depth];
}

static void
parser_data(void *user, const XML_Char *s, int len)
{
  //  dumpl("data", s, len);
  dynstring_add(&scope.data, s, len);
}

static void
parser_exec(void *user, const XML_Char *target, const XML_Char *data)
{
  dump("exec", target);
  dump("exec_args", data);
}

static void
parser_comment(void *user, const XML_Char *data)
{
  dump("-", data);
}

static void
parser_cdata(void *user)
{
  dump("[", "");
}

static void
parser_cdata_end(void *user)
{
  dump("]", "");
}

static void
parser_default(void *user, const XML_Char *s, int len)
{
  dumpl("#", s, len);
}


static void
parse(XML_Parser p, void *buf, int len, int end)
{
  if (!XML_Parse(p, buf, len, end))
    {
      fprintf(stderr, "parse error line=%d column=%d: %s\n",
	      XML_GetCurrentLineNumber(p),
	      XML_GetCurrentColumnNumber(p),
	      XML_ErrorString(XML_GetErrorCode(p)));
      exit(-1);
    }
}

int
main(int argc, char **argv)
{
  XML_Parser	p;
  int		got;
  char		buf[BUFSIZ], *arg0;

  arg0	= argv[0];
  if (argc>1 && argv[1][0]=='-')
    {
      alternate_output = 1;
      if (strcmp(argv[1], "-a"))
	argc	= 0;
      argv++;
      argc--;
    }
  if (argc<2)
    {
      fprintf(stderr, "Usage: %s [-a] id [tableprefix]\n", arg0);
      return 1;
    }
  id	= argv[1];
  if (argc>2)
    prefix	= argv[2];

  p	= XML_ParserCreate(NULL);
  if (!p)
    {
      perror("cannot init expat");
      return 1;
    }

  XML_SetElementHandler(p,			parser_start, parser_end);
  XML_SetCharacterDataHandler(p,		parser_data);
  XML_SetProcessingInstructionHandler(p,	parser_exec);
  XML_SetCommentHandler(p,			parser_comment);
  XML_SetCdataSectionHandler(p,			parser_cdata, parser_cdata_end);
  XML_SetDefaultHandlerExpand(p,		parser_default);
#if 0
  XML_SetUserData(p, p);
#endif

  while ((got=fread(buf, 1, sizeof buf, stdin))>0)
    parse(p, buf, got, 0);
  if (ferror(stdin))
    return -1;
  parse(p, buf, 0, 1);
  return 0;
}
