/* Convert non-UTF-8 (ISO-8859-1) into UTF-8.
 *
 * If you give any arg the data is transformed
 * directly in UTF-8, else it is just escaped,
 * into standard XML escape codes.
 */
#include <stdio.h>

int
main(int argc, char **argv)
{
  int	c;

  while ((c=getchar())!=EOF)
    {
      if (c>=0x80)
	{
	  if (argc<2)
	    {
	      // Keep it readable 8 bit
	      printf("&#x%02x;", c);
	      continue;
            }
	  // make it directly 
	  putchar(0xc0|(c>>6));	/* 1100 001x */
	  c&=0xbf;		/* 10xx xxxx */
	}
      putchar(c);
    }
  return ferror(stdin);
}
